/**************************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 **************************************************************************************

  $Id: Testapp.cpp 13949 2021-02-08 11:46:52Z RMayer $:

  Description:
    Demonstrate nXAPI functions

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2021-02-08  - remove netX API test function, now available in the "test console" program
                - updated file header to actual version
    2010-07-22  initial version

**************************************************************************************/

#include "OS_Includes.h"
#include "CifXConsole.h"

unsigned long g_ulTimerResolution                 = 1;        // Default timer resolution = 1 ms
unsigned long g_ulIOTimeout                       = 10;       // Default IO timeout = 10 ms
char          g_szBoard[CIFx_MAX_INFO_NAME_LENTH] = {0};
char          g_szFirmwareFile[MAX_PATH]          = "c:\\NTDPSDPS.NXF";
char          g_szConfigFile[MAX_PATH]            = "c:\\CONFIG.NXD";

//-------------------------------------------------
// Command line parameters and functions
// Program command line parameters

#define COMMAND_TIMEOUT    "-T:"
#define COMMAND_WAIT       "-W:"
#define COMMAND_BOARD      "-B:"
#define COMMAND_FWFILE     "-F:"
#define COMMAND_CONFIGFILE "-C:"

long TestnxAPI( char* pszBoardName, char* pszFullFileName);
void TestConnectorConfig( char* pszBoardName );

//=============================================================================
// Set string
//=============================================================================
void SetString(char* szArgument, void* pvDest)
{
  char* szDest = reinterpret_cast<char*>(pvDest);
  strcpy(szDest, szArgument);
}

//=============================================================================
// Set DWORD
//=============================================================================
void SetDWORD(char* szArgument, void* pvDest)
{
  unsigned long* pulDest = reinterpret_cast<unsigned long*>(pvDest);
  sscanf(szArgument, "%x", pulDest);
}

//=============================================================================
// Set string
//=============================================================================
typedef void(*PFN_COMMAND)(char*, void*);

typedef struct tagCMDLINE_PARAMS
{
  char*      szCommandPrefix;
  PFN_COMMAND pfnCommand;
  void*       pvData;
} CMDLINE_PARAM;


static CMDLINE_PARAM s_atCommands[] =
{
  {COMMAND_TIMEOUT,     SetDWORD,  &g_ulTimerResolution},
  {COMMAND_WAIT,        SetDWORD,  &g_ulIOTimeout},
  {COMMAND_BOARD,       SetString, &g_szBoard},
  {COMMAND_FWFILE,      SetString, &g_szFirmwareFile},
  {COMMAND_CONFIGFILE,  SetString, &g_szConfigFile}
};

//=============================================================================
// MAIN program
//
//
//=============================================================================
int main(int argc, char* argv[])
{
  //==============================================================
  // Get program parameter
  //==============================================================
  if (argc == 1)
  {
    //no arguments given
    printf("CifX Test Program - Help\r\n");
    printf("  Options: \r\n");
    printf("  -T: <Time resolution in milliseconds [1..n]>\r\n");
    printf("  -W: <IO wait timeout in milliseconds [1..n]>\r\n");
    printf("  -B: <cifX Board name cifX[0..n]>\r\n");
    printf("  -F: <Path to firmware file>\r\n");
    printf("  -C: <Path to config file>\r\n\n");

  } else
  {
    for(int iArg = 1; iArg < argc; iArg++)
    {
      bool fFound = false;

      for(unsigned int iCommand = 0; iCommand < sizeof(s_atCommands) / sizeof(s_atCommands[0]); iCommand++)
      {
        if(_strnicmp (argv[iArg],
                     s_atCommands[iCommand].szCommandPrefix,
                     strlen(s_atCommands[iCommand].szCommandPrefix)) == 0)
        {
          s_atCommands[iCommand].pfnCommand(argv[iArg] + strlen(s_atCommands[iCommand].szCommandPrefix),
                                            s_atCommands[iCommand].pvData);
          fFound = true;
          break;
        }
      }

      if(!fFound)
      {
        printf("Invalid option '%s'\r\n", argv[iArg]);
        return 0;
      }
    }
  }

  //==============================================================
  // Run cifX Console Test Application
  //==============================================================
  RunCifXConsoleTest(g_szBoard,
                     g_szFirmwareFile,
                     g_szConfigFile,
                     g_ulTimerResolution,
                     g_ulIOTimeout);

  //==============================================================
  // TEST nxAPI Connector configuration
  //==============================================================
  printf("\n\r Press (Y) for nxAPI Connector configuration or (Q) to skip!!!!!\r\n");
  if( 'Y' == OS_GetChar() )
  {
    TestConnectorConfig( g_szBoard);
  } else
  {
    printf("\r Function skipped\r\n");
  }

  /* Wait for user */
  printf("\n\r Press (Q) to close program!!!!!\r\n");
  OS_GetChar();

  return 0;
}
